/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.constants.OptionType;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogGuiSettings;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.Util;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiDialogInteract
extends GuiNPCInterface
implements IGuiClose {
    protected Dialog dialog;
    protected int selected = 0;
    protected final List<TextBlockClient> lines = new ArrayList<TextBlockClient>();
    protected int dialogHeight = 180;
    protected final ResourceLocation wheel = new ResourceLocation("customnpcs", "textures/gui/wheel.png");
    protected boolean isGrabbed = false;
    public static Map<Integer, ResourceLocation> icons = new LinkedHashMap<Integer, ResourceLocation>();
    protected final ResourceLocation npcSkin;
    protected final ResourceLocation playerSkin;
    protected final Map<Integer, List<String>> options = new TreeMap<Integer, List<String>>();
    protected int lineStart = 0;
    protected int lineTotal = 0;
    protected int lineVisibleSize;
    protected int[] scrollD = null;
    protected int selectedStart = 0;
    protected int selectedSize = 0;
    protected int selectedVisibleSize;
    protected final Map<Integer, Integer> selectedTotal = new HashMap<Integer, Integer>();
    protected int[] scrollO = null;
    protected int wheelList = 0;
    protected int selectedX = 0;
    protected int selectedY = 0;
    protected int selectedWheel = 0;
    protected long waitToAnswer;
    protected final Map<Integer, DialogTexture> textures = new HashMap<Integer, DialogTexture>();
    protected final EntityNPCInterface dialogNpc;
    protected int fontHeight;
    protected int startLine;
    protected long startTime;
    protected final float corr;
    private final DialogGuiSettings guiSettings;
    ScaledResolution sw = new ScaledResolution(this.field_146297_k);
    protected boolean showOptions;
    protected boolean newDialogSet;

    public GuiDialogInteract(EntityNPCInterface npc, Dialog dialogIn) {
        super(npc);
        this.drawDefaultBackground = false;
        this.ySize = 238;
        this.dialogNpc = Util.instance.copyToGUI(npc, (World)this.field_146297_k.field_71441_e, false);
        this.dialogNpc.display.setVisible(0);
        this.dialog = dialogIn;
        this.guiSettings = DialogController.instance.getGuiSettings();
        this.corr = this.field_146297_k.func_135016_M().func_135041_c().func_135034_a().equals("ru_ru") ? 1.14725f : 1.0f;
        this.playerSkin = PlayerSkinController.getInstance().playerTextures.get(this.player.func_110124_au()).get(MinecraftProfileTexture.Type.SKIN);
        if (npc.display.skinType == 0) {
            this.npcSkin = new ResourceLocation(npc.display.getSkinTexture());
        } else {
            ResourceLocation skin = DefaultPlayerSkin.func_177335_a();
            if (npc.display.skinType == 1) {
                if (npc.display.playerProfile == null) {
                    npc.display.loadProfile();
                }
                if (npc.display.playerProfile != null) {
                    PlayerSkinController pData = PlayerSkinController.getInstance();
                    Map<MinecraftProfileTexture.Type, ResourceLocation> map = pData.getData(npc.display.playerProfile.getId());
                    if (map != null && map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        skin = map.get(MinecraftProfileTexture.Type.SKIN);
                    } else {
                        Minecraft minecraft = Minecraft.func_71410_x();
                        Map mapMC = minecraft.func_152342_ad().func_152788_a(npc.display.playerProfile);
                        if (mapMC.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            skin = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)mapMC.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                        }
                    }
                }
            } else if (npc.display.skinType == 2) {
                try {
                    boolean fixSkin = npc instanceof EntityCustomNpc && ((EntityCustomNpc)npc).modelData.getEntity(npc) == null;
                    skin = new ResourceLocation("customnpcs", "skins/" + (npc.display.getSkinUrl() + fixSkin).hashCode() + (fixSkin ? "" : "32"));
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
            this.npcSkin = skin;
        }
        this.func_73866_w_();
        this.appendDialog(dialogIn);
    }

    public void appendDialog(Dialog d) {
        this.closeOnEsc = !d.disableEsc;
        this.newDialogSet = true;
        Dialog oldDialog = this.dialog;
        this.dialog = d.copy();
        this.options.clear();
        this.selected = 0;
        this.selectedStart = 0;
        MusicController.Instance.stopSound(null, SoundCategory.VOICE);
        if (d.sound != null && !d.sound.isEmpty()) {
            boolean isPlay;
            BlockPos pos = this.dialogNpc.func_180425_c();
            if (oldDialog != null && !oldDialog.equals(d) && oldDialog.sound != null && !oldDialog.sound.isEmpty() && MusicController.Instance.isPlaying(oldDialog.sound)) {
                MusicController.Instance.stopSound(oldDialog.sound, SoundCategory.VOICE);
            }
            if (isPlay = MusicController.Instance.isPlaying(d.sound)) {
                MusicController.Instance.stopSound(d.sound, SoundCategory.VOICE);
            }
            CustomNPCsScheduler.runTack(() -> MusicController.Instance.playSound(SoundCategory.VOICE, d.sound, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1.0f, 1.0f), 50);
        }
        this.startTime = System.currentTimeMillis();
        this.setStartLine();
        StringBuilder dText = new StringBuilder(new TextComponentTranslation(d.text, new Object[0]).func_150254_d());
        while (dText.toString().contains("<br>")) {
            dText = new StringBuilder(dText.toString().replace("<br>", "\n"));
        }
        while (dText.toString().contains("\\n")) {
            dText = new StringBuilder(dText.toString().replace("\\n", "\n"));
        }
        ResourceLocation txtr = null;
        int[] txtrSize = null;
        if (!d.texture.isEmpty()) {
            txtr = new ResourceLocation(d.texture);
            this.field_146297_k.func_110434_K().func_110577_a(txtr);
            try {
                IResource res = this.field_146297_k.func_110442_L().func_110536_a(new ResourceLocation(d.texture));
                BufferedImage buffer = ImageIO.read(res.func_110527_b());
                txtrSize = new int[]{buffer.getWidth(), buffer.getHeight(), (int)Math.ceil((double)buffer.getHeight() / (double)this.fontHeight / 2.0)};
            }
            catch (IOException e) {
                LogWriter.error(e);
            }
        }
        if (txtrSize != null) {
            for (int i = 0; i < txtrSize[2]; ++i) {
                dText.append("\n");
            }
        }
        int textWidth = this.guiSettings.dialogWidth - (int)(13.0f * this.corr);
        this.lines.add(new TextBlockClient(this.dialogNpc, dText.toString(), textWidth, 0xE0E0E0, (Entity)this.dialogNpc, new Object[]{this.player, this.npc}));
        if (!d.showFits) {
            this.setStartLine();
        }
        this.resetOptions();
        this.grabMouse(d.showWheel);
        this.waitToAnswer = this.dialog != null ? System.currentTimeMillis() + (long)this.dialog.delay * 50L : 0L;
        this.lineTotal = 0;
        for (TextBlockClient textBlock : this.lines) {
            this.lineTotal += 1 + textBlock.lines.size();
        }
        this.selectedTotal.clear();
        int i = 0;
        this.selectedSize = 0;
        for (int id : this.options.keySet()) {
            this.selectedTotal.put(i, this.options.get(id).size());
            this.selectedSize += this.options.get(id).size();
            ++i;
        }
        this.lineVisibleSize = this.dialogHeight / this.fontHeight;
        this.selectedVisibleSize = Math.round((float)(this.field_146295_m - this.dialogHeight - 2) / (float)this.fontHeight);
        this.selected = 0;
        this.selectedStart = 0;
        if (this.lineStart < 0) {
            this.lineStart = 0;
        }
        if (txtr != null && txtrSize != null && !this.textures.containsKey(this.lineTotal - 1 - txtrSize[2])) {
            this.textures.put(this.lineTotal - 1 - txtrSize[2], new DialogTexture(txtr, txtrSize, this.lines.get(this.lines.size() - 1)));
        }
        this.func_73866_w_();
    }

    protected void checkSelected() {
        int selSize = 0;
        int pos = 1;
        for (int i = this.selectedTotal.size() - 1; i > 0 && (selSize += this.selectedTotal.get(i).intValue()) < this.selectedVisibleSize; --i) {
            ++pos;
        }
        if (this.selectedStart <= 0) {
            this.selectedStart = 0;
            if (this.scrollO != null) {
                this.scrollO[8] = this.selectedStart;
                this.scrollO[7] = this.mouseY;
            }
        } else if (this.selectedStart >= this.selectedTotal.size() - pos) {
            this.selectedStart = this.selectedTotal.size() - pos;
            if (this.scrollO != null) {
                this.scrollO[8] = this.selectedStart;
                this.scrollO[7] = this.mouseY;
            }
        }
    }

    @Override
    public void close() {
        this.grabMouse(false);
        if (this.dialog.sound != null && !this.dialog.sound.isEmpty() && this.dialog.stopSound && MusicController.Instance.isPlaying(this.dialog.sound)) {
            MusicController.Instance.stopSound(this.dialog.sound, SoundCategory.VOICE);
        }
        NoppesUtilPlayer.sendData(EnumPlayerPacket.CheckQuestCompletion, 0);
        super.close();
    }

    @Override
    public void save() {
        ClientProxy.playerData.dialogData.addLogs(this.lines, this.npcSkin.toString());
        NBTTagCompound compound = new NBTTagCompound();
        ClientProxy.playerData.dialogData.saveNBTData(compound);
        NoppesUtilPlayer.sendData(EnumPlayerPacket.PlayerDialogData, compound);
    }

    protected void drawLinedOptions() {
        int i = 0;
        int optPos = 0;
        int endW = this.guiSettings.guiRight - 1;
        int left = this.guiLeft + 24;
        int addX = 0;
        if (this.selectedSize > this.selectedVisibleSize && !this.dialog.showWheel) {
            left += 13;
        }
        if (this.selectedSize > this.selectedVisibleSize) {
            endW -= 13;
            if (!this.dialog.showWheel) {
                left += 13;
            }
            if (this.guiSettings.getType() == 2) {
                addX = 13;
            } else {
                left -= 12;
            }
        }
        for (int id : this.options.keySet()) {
            if (optPos < this.selectedStart) {
                ++optPos;
                continue;
            }
            DialogOption option = this.dialog.options.get(id);
            List<String> lines = this.options.get(id);
            int j = 0;
            for (String sct : lines) {
                if (j == 0) {
                    this.func_73731_b(this.field_146289_q, optPos == this.selected ? "->" : " *", this.guiLeft + 1 + (icons.containsKey(option.iconId) ? 0 : 10) + addX, this.dialogHeight + i * this.fontHeight, this.guiSettings.pointerColor);
                    if (i != 0 && optPos - 1 != this.selected) {
                        this.func_73730_a(this.guiLeft + 2 + addX, endW + addX, this.dialogHeight + i * this.fontHeight, this.guiSettings.scrollLineColor);
                    }
                    if (this.selected == optPos) {
                        this.func_73730_a(left, endW + addX, this.dialogHeight + i * this.fontHeight, this.guiSettings.hoverLineColor);
                    }
                    if (icons.containsKey(option.iconId)) {
                        this.field_146297_k.func_110434_K().func_110577_a(icons.get(option.iconId));
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)((float)this.guiLeft + 11.5f + (float)addX), (float)((float)(this.dialogHeight + i * this.fontHeight) + 1.0f), (float)0.0f);
                        GlStateManager.func_179131_c((float)((float)(option.optionColor >> 16 & 0xFF) / 255.0f), (float)((float)(option.optionColor >> 8 & 0xFF) / 255.0f), (float)((float)(option.optionColor & 0xFF) / 255.0f), (float)1.0f);
                        float s = 0.046875f;
                        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                        this.func_73729_b(0, 0, 0, 0, 256, 256);
                        GlStateManager.func_179121_F();
                    }
                }
                if (this.selected == optPos) {
                    GuiDialogInteract.fill(left, this.dialogHeight + i * this.fontHeight + (j == 0 ? 1 : 0), endW + addX, this.dialogHeight + (i + 1) * this.fontHeight, this.field_73735_i, this.guiSettings.selectOptionLeftColor, this.guiSettings.selectOptionRightColor);
                }
                this.func_73731_b(this.field_146289_q, sct, left, this.dialogHeight + i * this.fontHeight, option.optionColor);
                ++i;
                if (++j != lines.size()) continue;
                this.func_73730_a(this.guiLeft + 2 + addX, endW + addX, this.dialogHeight + i * this.fontHeight, this.guiSettings.scrollLineColor);
                if (this.selected != optPos) continue;
                this.func_73730_a(left, endW + addX, this.dialogHeight + i * this.fontHeight, this.guiSettings.hoverLineColor);
            }
            ++optPos;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int vType = this.guiSettings.getShowVerticalLines();
        int hType = this.guiSettings.getShowVerticalLines();
        int blurringLine = (int)((float)this.guiSettings.dialogWidth * this.guiSettings.getBlurringLine());
        if (this.guiSettings.backTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiSettings.backTexture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)((float)this.field_146294_l / 256.0f), (float)((float)this.field_146295_m / 256.0f), (float)1.0f);
            this.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179121_F();
        }
        if (this.guiSettings.windowTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiSettings.windowTexture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiSettings.guiLeft, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)((float)this.guiSettings.dialogWidth / 256.0f), (float)((float)this.field_146295_m / 256.0f), (float)1.0f);
            this.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179121_F();
        }
        switch (this.guiSettings.getType()) {
            case 0: {
                int left = this.guiLeft + blurringLine;
                if (blurringLine > 0) {
                    GuiDialogInteract.fill(this.guiLeft, 0, left, this.field_146295_m, this.field_73735_i, this.guiSettings.backBorderColor, this.guiSettings.backWindowColor);
                }
                GuiDialogInteract.fill(left, 0, this.field_146294_l, this.field_146295_m, this.field_73735_i, this.guiSettings.backWindowColor, this.guiSettings.backWindowColor);
                GuiDialogInteract.fill(0, 0, this.guiLeft, this.field_146295_m, this.field_73735_i, this.guiSettings.backBorderColor, this.guiSettings.backBorderColor);
                if (vType != 0) {
                    int lX = this.guiLeft - 1;
                    if (hType == 2) {
                        this.func_73728_b(lX, 0, this.dialogHeight - 2, this.guiSettings.linesColor);
                        this.func_73728_b(lX, this.dialogHeight - 2, this.field_146295_m - 2, this.guiSettings.linesColor);
                        lX = this.guiLeft - 3;
                    } else if (hType == 1) {
                        this.func_73728_b(lX, 0, this.field_146295_m - 2, this.guiSettings.linesColor);
                        lX = this.guiLeft - 3;
                    }
                    if (vType == 2) {
                        this.func_73728_b(lX, 1, this.field_146295_m - 2, this.guiSettings.linesColor);
                    }
                }
                if (hType == 2) {
                    this.func_73730_a(this.guiLeft, this.field_146294_l - 3, this.dialogHeight - 3, this.guiSettings.linesColor);
                    this.func_73730_a(this.guiLeft, this.field_146294_l - 3, this.dialogHeight - 1, this.guiSettings.linesColor);
                    break;
                }
                if (hType != 1) break;
                this.func_73730_a(this.guiLeft, this.field_146294_l - 3, this.dialogHeight - 2, this.guiSettings.linesColor);
                break;
            }
            case 1: {
                int left = this.guiLeft + blurringLine;
                int right = this.guiSettings.guiRight - blurringLine;
                if (blurringLine > 0) {
                    GuiDialogInteract.fill(this.guiLeft, 0, left, this.field_146295_m, this.field_73735_i, this.guiSettings.backBorderColor, this.guiSettings.backWindowColor);
                }
                GuiDialogInteract.fill(left, 0, right, this.field_146295_m, this.field_73735_i, this.guiSettings.backWindowColor, this.guiSettings.backWindowColor);
                if (blurringLine > 0) {
                    GuiDialogInteract.fill(right, 0, this.guiSettings.guiRight, this.field_146295_m, this.field_73735_i, this.guiSettings.backWindowColor, this.guiSettings.backBorderColor);
                }
                GuiDialogInteract.fill(0, 0, this.guiLeft, this.field_146295_m, this.field_73735_i, this.guiSettings.backBorderColor, this.guiSettings.backBorderColor);
                GuiDialogInteract.fill(this.guiSettings.guiRight, 0, this.field_146294_l, this.field_146295_m, this.field_73735_i, this.guiSettings.backBorderColor, this.guiSettings.backBorderColor);
                if (vType != 0) {
                    int lX = this.guiSettings.guiLeft - 1;
                    int rX = this.guiSettings.guiRight + 1;
                    if (hType == 2) {
                        this.func_73728_b(lX, 0, this.dialogHeight - 2, this.guiSettings.linesColor);
                        this.func_73728_b(lX, this.dialogHeight - 2, this.field_146295_m - 2, this.guiSettings.linesColor);
                        this.func_73728_b(rX, 0, this.dialogHeight - 2, this.guiSettings.linesColor);
                        this.func_73728_b(rX, this.dialogHeight - 2, this.field_146295_m - 2, this.guiSettings.linesColor);
                        lX = this.guiLeft - 3;
                        rX += 2;
                    } else if (hType == 1) {
                        this.func_73728_b(lX, 0, this.field_146295_m - 2, this.guiSettings.linesColor);
                        this.func_73728_b(rX, 0, this.field_146295_m - 2, this.guiSettings.linesColor);
                        lX = this.guiLeft - 3;
                        rX += 2;
                    }
                    if (vType == 2) {
                        this.func_73728_b(lX, 0, this.field_146295_m - 2, this.guiSettings.linesColor);
                        this.func_73728_b(rX, 0, this.field_146295_m - 2, this.guiSettings.linesColor);
                    }
                }
                if (hType == 2) {
                    this.func_73730_a(this.guiLeft, this.guiSettings.guiRight, this.dialogHeight - 3, this.guiSettings.linesColor);
                    this.func_73730_a(this.guiLeft, this.guiSettings.guiRight, this.dialogHeight - 1, this.guiSettings.linesColor);
                    break;
                }
                if (hType != 1) break;
                this.func_73730_a(this.guiLeft, this.guiSettings.guiRight, this.dialogHeight - 2, this.guiSettings.linesColor);
                break;
            }
            case 2: {
                int right = this.guiSettings.guiRight - blurringLine;
                GuiDialogInteract.fill(0, 0, right, this.field_146295_m, this.field_73735_i, this.guiSettings.backWindowColor, this.guiSettings.backWindowColor);
                if (blurringLine > 0) {
                    GuiDialogInteract.fill(right, 0, this.guiSettings.dialogWidth, this.field_146295_m, this.field_73735_i, this.guiSettings.backWindowColor, this.guiSettings.backBorderColor);
                }
                GuiDialogInteract.fill(this.guiSettings.dialogWidth, 0, this.field_146294_l, this.field_146295_m, this.field_73735_i, this.guiSettings.backBorderColor, this.guiSettings.backBorderColor);
                if (vType != 0) {
                    int rX = this.guiSettings.guiRight + 1;
                    if (hType == 2) {
                        this.func_73728_b(rX, 0, this.dialogHeight - 2, this.guiSettings.linesColor);
                        this.func_73728_b(rX, this.dialogHeight - 2, this.field_146295_m - 2, this.guiSettings.linesColor);
                        rX += 2;
                    } else if (hType == 1) {
                        this.func_73728_b(rX, 0, this.field_146295_m - 2, this.guiSettings.linesColor);
                        rX += 2;
                    }
                    if (vType == 2) {
                        this.func_73728_b(rX, 0, this.field_146295_m - 2, this.guiSettings.linesColor);
                    }
                }
                if (hType == 2) {
                    this.func_73730_a(this.guiLeft, this.guiSettings.guiRight, this.dialogHeight - 3, this.guiSettings.linesColor);
                    this.func_73730_a(this.guiLeft, this.guiSettings.guiRight, this.dialogHeight - 1, this.guiSettings.linesColor);
                    break;
                }
                if (hType != 1) break;
                this.func_73730_a(this.guiLeft, this.guiSettings.guiRight, this.dialogHeight - 2, this.guiSettings.linesColor);
                break;
            }
        }
        if (this.guiSettings.showNPC && !this.dialog.hideNPC && this.dialogNpc != null) {
            this.drawNpc((Entity)this.dialogNpc, this.guiSettings.npcPosX, this.guiSettings.npcPosY, this.guiSettings.getNpcScale(), this.guiSettings.getType() == 2 || this.guiSettings.getType() == 1 && !this.guiSettings.npcInLeft ? 40 : -40, 15, this.dialog.showWheel ? 0 : 2);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.guiSettings.backTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiSettings.backTexture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)1.6679688f, (float)0.9375f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179121_F();
        }
        if (this.guiSettings.windowTexture != null) {
            this.field_146297_k.func_110434_K().func_110577_a(this.guiSettings.windowTexture);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiSettings.guiLeft, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)((float)this.guiSettings.dialogWidth / 427.0f * 1.6679688f), (float)0.9375f, (float)1.0f);
            this.func_73729_b(0, 0, 0, 0, 256, 256);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)100.065f);
        int time = 1 + (int)((System.currentTimeMillis() - this.startTime) / (1000L / (long)CustomNpcs.DialogShowFitsSpeed));
        int l = 0;
        this.showOptions = true;
        GlStateManager.func_179094_E();
        GL11.glEnable((int)3089);
        int i = this.field_146297_k.field_71440_d;
        double d4 = this.sw.func_78326_a() < this.field_146297_k.field_71443_c ? (double)((int)Math.round((double)this.field_146297_k.field_71443_c / (double)this.sw.func_78326_a())) : 1.0;
        double d5 = (double)this.guiLeft * d4;
        double d6 = (double)i - (double)(this.dialogHeight - 3) * d4;
        double d7 = (double)(this.guiSettings.dialogWidth + 1) * d4;
        double d8 = (double)(this.dialogHeight - 3) * d4;
        GL11.glScissor((int)((int)d5), (int)((int)d6), (int)Math.max(0, (int)d7), (int)Math.max(0, (int)d8));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (TextBlockClient textBlock : new ArrayList<TextBlockClient>(this.lines)) {
            int left = ClientProxy.Font.width(textBlock.getName() + ": ");
            if (l >= this.lineStart) {
                this.drawString(textBlock.getName() + ": ", 0, textBlock.color, l);
            }
            for (ITextComponent line : textBlock.lines) {
                if (this.newDialogSet && l >= this.lineStart + this.lineVisibleSize) {
                    this.lineStart = l - this.lineVisibleSize + 1;
                }
                if (l < this.lineStart) {
                    ++l;
                    continue;
                }
                if (this.dialog.showFits && this.startLine == l) {
                    String text = line.func_150254_d();
                    while (text.endsWith("\u00a7r")) {
                        text = text.substring(0, text.length() - 2);
                    }
                    while (text.startsWith("\u00a7r")) {
                        text = text.substring(2);
                    }
                    if (text.length() >= time) {
                        this.drawString(text.substring(0, time), left, textBlock.color, l);
                        if (text.length() == time) {
                            ++this.startLine;
                            this.startTime = System.currentTimeMillis();
                        }
                        this.showOptions = false;
                        break;
                    }
                }
                this.drawString(line.func_150254_d(), left, textBlock.color, l);
                ++l;
            }
            ++l;
        }
        GlStateManager.func_179121_F();
        if (!this.textures.isEmpty()) {
            Iterator<Object> iterator = this.textures.keySet().iterator();
            while (iterator.hasNext()) {
                int tys;
                int tye;
                int linePos = (Integer)iterator.next();
                DialogTexture dt = this.textures.get(linePos);
                if (dt.left < this.guiLeft || (tye = (tys = this.fontHeight * (linePos - this.lineStart)) + dt.vS / 2) < 0 || tys > this.dialogHeight - 4) continue;
                int s = (tys < 0 ? -1 * tys : 0) * 2;
                int e = 256 - s;
                int pH = Math.max(tys, 0);
                int v = 0;
                if (pH == 0) {
                    v = 1;
                    pH = 1;
                    ++s;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                this.field_146297_k.func_110434_K().func_110577_a(dt.res);
                GlStateManager.func_179109_b((float)dt.left, (float)pH, (float)0.0f);
                float sc = (float)Math.max(dt.uS, dt.vS) / 256.0f;
                GlStateManager.func_179152_a((float)(sc / 2.0f), (float)(sc / 2.0f), (float)1.0f);
                if ((float)pH + (float)e * sc / 2.0f > (float)(this.dialogHeight - 4)) {
                    e = (int)((float)((this.dialogHeight - 4 - pH) * 2) / sc);
                }
                this.func_73729_b(0, v, 0, s, 256, e);
                GlStateManager.func_179121_F();
            }
        }
        GL11.glDisable((int)3089);
        GlStateManager.func_179121_F();
        if (!this.options.isEmpty()) {
            if (this.waitToAnswer > System.currentTimeMillis()) {
                int offset = this.dialogHeight;
                this.func_73731_b(this.field_146289_q, "\u00a7e" + new TextComponentTranslation("gui.wait", new Object[]{"\u00a7e: \u00a7f" + Util.instance.ticksToElapsedTime((this.waitToAnswer - System.currentTimeMillis()) / 50L, false, false, false)}).func_150254_d(), this.guiLeft + 25, this.dialogHeight, 0xFFFFFF);
                this.showOptions = false;
            }
            if (this.showOptions) {
                if (!this.dialog.showWheel) {
                    this.drawLinedOptions();
                } else {
                    this.drawWheel();
                }
            }
        }
        if (this.showOptions) {
            if (this.newDialogSet && this.lineTotal == l) {
                this.newDialogSet = false;
            }
            if (this.lineTotal > this.lineVisibleSize) {
                int x = this.guiSettings.guiRight - 10;
                int r = this.guiSettings.guiRight - 13;
                if (this.guiSettings.getType() == 2) {
                    x = 1;
                    r = 12;
                }
                int y = 1;
                int hd = this.dialogHeight - 5;
                float ms = (float)this.lineVisibleSize / (float)this.lineTotal;
                int sHeight = (int)(ms * (float)hd);
                y += (int)((float)(hd - sHeight) * (float)this.lineStart / (float)(this.lineTotal - this.lineVisibleSize));
                if (this.scrollD == null) {
                    this.scrollD = new int[9];
                }
                this.scrollD[0] = x;
                this.scrollD[1] = y;
                this.scrollD[2] = x + 9;
                this.scrollD[3] = Math.min(y + sHeight, this.dialogHeight - 4);
                this.scrollD[4] = 1;
                this.scrollD[5] = hd;
                this.scrollD[6] = (int)(((float)hd - (float)sHeight) / (float)(this.lineTotal - this.lineVisibleSize));
                GuiDialogInteract.fill(this.scrollD[0], this.scrollD[1], this.scrollD[2], this.scrollD[3], this.field_73735_i, this.guiSettings.sliderColor, this.guiSettings.sliderColor);
                this.func_73728_b(r, 0, this.dialogHeight - 4, this.guiSettings.linesColor);
            } else {
                this.scrollD = null;
            }
            if (this.selectedSize > this.selectedVisibleSize && !this.dialog.showWheel) {
                int x = this.guiSettings.guiRight - 10;
                int r = this.guiSettings.guiRight - 13;
                if (this.guiSettings.getType() == 2) {
                    x = 1;
                    r = 12;
                }
                int y = this.dialogHeight + 1;
                int hd = this.field_146295_m - this.dialogHeight - 2;
                float ms = (float)this.selectedVisibleSize / (float)this.selectedTotal.size();
                int sHeight = (int)(ms * (float)hd);
                y += (int)((float)(hd - sHeight) * (float)this.selectedStart / (float)(this.selectedTotal.size() - this.selectedVisibleSize));
                if (this.scrollO == null) {
                    this.scrollO = new int[9];
                }
                this.scrollO[0] = x;
                this.scrollO[1] = y;
                this.scrollO[2] = x + 7;
                this.scrollO[3] = Math.min(y + sHeight, this.field_146295_m - 1);
                this.scrollO[4] = this.dialogHeight + 1;
                this.scrollO[5] = hd;
                this.scrollO[6] = (int)(((float)hd - (float)sHeight) / (float)(this.selectedTotal.size() - this.selectedVisibleSize));
                GuiDialogInteract.fill(this.scrollO[0], this.scrollO[1], this.scrollO[2], this.scrollO[3], this.field_73735_i, this.guiSettings.sliderColor, this.guiSettings.sliderColor);
                this.func_73728_b(r, this.dialogHeight, this.field_146295_m - 1, this.guiSettings.linesColor);
            } else {
                this.scrollO = null;
            }
            int drag = Mouse.getDWheel() / 120;
            if (this.lineTotal > this.lineVisibleSize && drag != 0 && this.isMouseHover(mouseX, mouseY, this.guiLeft, 0, this.guiSettings.dialogWidth, this.dialogHeight)) {
                this.lineStart -= drag;
                if (this.lineStart < 0) {
                    this.lineStart = 0;
                } else if (this.lineStart > this.lineTotal - this.lineVisibleSize) {
                    this.lineStart = this.lineTotal - this.lineVisibleSize;
                }
            }
            if (this.isMouseHover(mouseX, mouseY, this.guiLeft, this.dialogHeight, this.guiSettings.dialogWidth, this.field_146295_m - this.dialogHeight)) {
                if (this.selectedSize > this.selectedVisibleSize && drag != 0) {
                    this.selectedStart -= drag;
                    this.checkSelected();
                }
                int y = (int)Math.floor(((double)mouseY - (double)this.dialogHeight) / (double)this.fontHeight);
                i = 0;
                int optPos = 0;
                this.selected = -1;
                for (List<String> list : this.options.values()) {
                    if (optPos < this.selectedStart) {
                        ++optPos;
                        continue;
                    }
                    for (String opt : list) {
                        if (i == y) {
                            this.selected = optPos;
                            break;
                        }
                        ++i;
                    }
                    if (this.selected != -1) break;
                    ++optPos;
                }
                if (this.selected == -1) {
                    this.selected = this.options.size() - 1;
                }
            }
        }
    }

    public void func_73731_b(@Nonnull FontRenderer fontRendererIn, @Nonnull String text, int x, int y, int color) {
        ClientProxy.Font.drawString(text, x, y, color);
    }

    protected void drawString(String text, int left, int color, int linePos) {
        int height = (linePos - this.lineStart) * this.fontHeight;
        int line = this.guiTop + this.dialogHeight - this.fontHeight / 3;
        if (height > line) {
            return;
        }
        int x = this.guiLeft + 1 + left;
        if (this.guiSettings.getType() == 2 && this.lineTotal > this.lineVisibleSize) {
            x += 13;
        }
        this.func_73731_b(this.field_146289_q, text, x, this.guiTop + height, color);
        if (this.textures.containsKey(linePos)) {
            this.textures.get((Object)Integer.valueOf((int)linePos)).left = this.guiLeft + 1 + left;
        }
    }

    protected void drawWheel() {
        int j;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int center = this.guiSettings.dialogWidth / 2;
        GlStateManager.func_179109_b((float)(this.guiLeft + center), (float)(this.guiTop + this.dialogHeight + 14), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.wheel);
        this.func_73729_b(0, 0, 0, 0, 63, 40);
        int mdx = Mouse.getDX();
        int mdy = Mouse.getDY();
        int maxLists = (int)Math.ceil((double)this.options.size() / 6.0) - 1;
        this.selectedX += mdx;
        this.selectedY += mdy;
        float a = 118.0f;
        float b = 65.0f;
        double inB = Math.pow(this.selectedX, 2.0) / Math.pow(a, 2.0) + Math.pow(this.selectedY, 2.0) / Math.pow(b, 2.0);
        if (inB > 1.0) {
            this.selectedX -= mdx;
            this.selectedY -= mdy;
        }
        this.selectedWheel = 0;
        if (this.options.size() > 6) {
            this.func_73729_b(17, 7, 63, 0, 30, 18);
            if (this.wheelList == 0) {
                this.func_73729_b(17, 7, 93, 0, 15, 18);
            } else if (this.wheelList >= maxLists) {
                this.func_73729_b(32, 7, 108, 0, 15, 18);
            }
            a = 55.0f;
            b = 34.0f;
            inB = Math.pow(this.selectedX, 2.0) / Math.pow(a, 2.0) + Math.pow(this.selectedY - 10, 2.0) / Math.pow(b, 2.0);
            if (inB < 1.0) {
                this.selected = -1;
                int n = this.selectedWheel = this.selectedX > 0 ? 2 : 1;
            }
        }
        if (this.selectedWheel == 0) {
            double rot;
            double xVal = -this.selectedX;
            double yVal = -this.selectedY;
            double rad = 57.29577951308232;
            if (xVal == 0.0) {
                rot = this.selectedY > 0 ? 180.0 : 0.0;
            } else {
                double v = Math.atan(yVal / xVal) * rad;
                rot = xVal <= 0.0 ? 90.0 + v : 270.0 + v;
            }
            rot %= 360.0;
            if (rot < 0.0) {
                rot += 360.0;
            }
            this.selected = rot > 122.0 && rot <= 180.0 ? this.wheelList * 6 : (rot > 85.0 && rot <= 122.0 ? 1 + this.wheelList * 6 : (rot > 0.0 && rot <= 85.0 ? 2 + this.wheelList * 6 : (rot > 275.0 && rot <= 360.0 ? 3 + this.wheelList * 6 : (rot > 238.0 && rot <= 275.0 ? 4 + this.wheelList * 6 : 5 + this.wheelList * 6))));
        } else {
            if (this.wheelList == 0 && this.selectedWheel == 1) {
                this.selectedWheel = 0;
            } else if (this.selectedWheel == 2 && this.wheelList >= maxLists) {
                this.selectedWheel = 0;
            }
            if (this.selectedWheel != 0) {
                this.selected = -1;
                int wu = 123 + (this.selectedWheel == 1 ? 0 : 15);
                this.func_73729_b(17 + (this.selectedWheel == 1 ? 0 : 15), 7, wu, 0, 15, 18);
            }
        }
        if (this.wheelList >= maxLists) {
            int slot = this.selected < 0 ? this.options.size() - this.options.size() % 6 : this.selected - this.selected % 6;
            for (j = 0; j < 6; ++j) {
                if (slot >= this.options.size()) {
                    int u = 63 * (slot % 3);
                    int v = 40 * (int)(3.0 + Math.floor((double)slot % 6.0 / 3.0));
                    this.func_73729_b(0, 0, u, v, 63, 40);
                    if (slot == this.selected) {
                        this.selected = -1;
                    }
                }
                ++slot;
            }
        }
        if (this.selected >= 0) {
            this.func_73729_b(0, 0, 63 * (this.selected % 3), 40 * (int)(1.0 + Math.floor((double)this.selected % 6.0 / 3.0)), 63, 40);
        }
        this.func_73729_b(30 + this.selectedX / 4, 17 - this.selectedY / 4, 63, 18, 3, 3);
        int slot = this.wheelList * 6;
        for (j = 0; j < 6; ++j) {
            Dialog d;
            DialogOption option = this.dialog.options.get(slot);
            if (option != null && option.optionType != OptionType.DISABLED && !option.title.isEmpty() && ((d = option.getDialog((EntityPlayer)this.player)) == null || d.availability.isAvailable((EntityPlayer)this.player))) {
                String wTitle;
                StringBuilder text;
                int color = option.optionColor;
                if (slot == this.selected) {
                    color = 8622040;
                }
                if ((float)this.field_146289_q.func_78256_a((text = new StringBuilder(wTitle = new TextComponentTranslation(option.title, new Object[0]).func_150254_d())).toString()) * this.corr > (float)(center - 5)) {
                    text = new StringBuilder();
                    for (int c = 0; c < wTitle.length(); ++c) {
                        char ch = wTitle.charAt(c);
                        StringBuilder stringBuilder = new StringBuilder();
                        if ((float)this.field_146289_q.func_78256_a(stringBuilder.append(text.toString()).append(ch).toString()) * this.corr > (float)(center - 5)) {
                            text.append("...");
                            break;
                        }
                        text.append(ch);
                    }
                }
                int height = this.getFontHeight(text.toString());
                int u = 0;
                int v = 0;
                switch (slot % 6) {
                    case 0: {
                        u = 62;
                        v = 1 - height;
                        break;
                    }
                    case 1: {
                        u = 68;
                        v = 13 - height / 2;
                        break;
                    }
                    case 2: {
                        u = 62;
                        v = 27;
                        break;
                    }
                    case 3: {
                        u = -ClientProxy.Font.width(text.toString());
                        v = 27;
                        break;
                    }
                    case 4: {
                        u = -5 - ClientProxy.Font.width(text.toString());
                        v = 13 - height / 2;
                        break;
                    }
                    case 5: {
                        u = -ClientProxy.Font.width(text.toString());
                        v = 1 - height;
                    }
                }
                this.func_73731_b(this.field_146289_q, text.toString(), u, v, color);
            }
            ++slot;
        }
        GlStateManager.func_179121_F();
    }

    protected int getFontHeight(String str) {
        int h = ClientProxy.Font.height(str);
        return h <= 1 ? 13 : h;
    }

    public int getSelected() {
        int i = 0;
        int last = -1;
        for (int id : this.options.keySet()) {
            if (i == this.selected || this.selected < 0) {
                return id;
            }
            ++i;
            last = id;
        }
        return last;
    }

    public void grabMouse(boolean grab) {
        if (grab && !this.isGrabbed) {
            Minecraft.func_71410_x().field_71417_B.func_74372_a();
            this.isGrabbed = true;
        } else if (!grab && this.isGrabbed) {
            Minecraft.func_71410_x().field_71417_B.func_74373_b();
            this.isGrabbed = false;
        }
    }

    protected void handleDialogSelection() {
        int optionId = this.getSelected();
        if (!this.options.containsKey(optionId)) {
            if (this.options.isEmpty() && this.closeOnEsc) {
                this.close();
            }
            return;
        }
        NoppesUtilPlayer.sendData(EnumPlayerPacket.Dialog, this.dialog.id, optionId);
        if (this.dialog == null || this.dialog.notHasOtherOptions() || this.options.isEmpty()) {
            if (this.closeOnEsc) {
                this.close();
            }
            return;
        }
        DialogOption option = this.dialog.options.get(optionId);
        if (option == null || option.optionType != OptionType.DIALOG_OPTION && option.optionType != OptionType.ROLE_OPTION) {
            if (this.closeOnEsc) {
                this.close();
            }
            return;
        }
        this.lines.add(new TextBlockClient(this.player.getDisplayNameString(), option.title, this.guiSettings.dialogWidth, option.optionColor, (Entity)this.dialogNpc, new Object[]{this.player, this.dialogNpc}));
        NoppesUtil.clickSound();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.sw = new ScaledResolution(this.field_146297_k);
        this.guiSettings.init(this.sw.func_78327_c(), this.sw.func_78324_d());
        if (this.dialogNpc != null && this.guiSettings.showNPC) {
            void var3_7;
            boolean addDots = false;
            String name = this.npc.func_70005_c_();
            while (this.field_146289_q.func_78256_a(name) > this.guiSettings.npcWidth && name.length() > 2) {
                name = name.substring(0, name.length() - 2);
                addDots = true;
            }
            if (addDots) {
                name = name + "...";
            }
            this.dialogNpc.display.setName(name);
            addDots = false;
            String string = this.dialogNpc.display.getTitle();
            while (this.field_146289_q.func_78256_a((String)var3_7) > this.guiSettings.npcWidth && var3_7.length() > 2) {
                String string2 = var3_7.substring(0, var3_7.length() - 2);
                addDots = true;
            }
            if (addDots) {
                this.dialogNpc.display.setTitle((String)var3_7 + "...");
            }
        }
        this.isGrabbed = false;
        this.grabMouse(this.dialog.showWheel);
        this.guiLeft = this.guiSettings.guiLeft;
        this.guiTop = 0;
        this.fontHeight = this.getFontHeight(null);
        this.field_146294_l = (int)Math.ceil(this.sw.func_78327_c());
        this.field_146295_m = (int)Math.ceil(this.sw.func_78324_d());
        int optionHeight = this.dialog.showWheel ? 60 : this.guiSettings.optionHeight;
        this.dialogHeight = this.field_146295_m - optionHeight;
        if (!this.lines.isEmpty()) {
            int max = this.guiSettings.dialogWidth - (int)(2.0f + (float)this.field_146289_q.func_78256_a((this.dialogNpc != null ? this.dialogNpc.func_70005_c_() : this.npc.func_70005_c_()) + ": ") / this.corr);
            if (this.lineTotal > this.lineVisibleSize) {
                max -= (int)(18.0f / this.corr);
            }
            for (TextBlockClient textBlock2 : this.lines) {
                textBlock2.lines.clear();
                textBlock2.resetWidth(max, false);
            }
        }
        if (!this.options.isEmpty()) {
            this.resetOptions();
        }
        this.lineTotal = 0;
        for (TextBlockClient textBlockClient : this.lines) {
            this.lineTotal += 1 + textBlockClient.lines.size();
        }
        this.selectedTotal.clear();
        int i = 0;
        this.selectedSize = 0;
        for (int id : this.options.keySet()) {
            this.selectedTotal.put(i, this.options.get(id).size());
            this.selectedSize += this.options.get(id).size();
            ++i;
        }
        this.lineVisibleSize = this.dialogHeight / this.fontHeight;
        this.selectedVisibleSize = Math.round((float)(this.field_146295_m - this.dialogHeight - 2) / (float)this.fontHeight);
        this.selected = 0;
        this.selectedStart = 0;
        this.lineStart = this.lineTotal - this.lineVisibleSize;
        if (this.lineStart < 0) {
            this.lineStart = 0;
        }
        if (!this.textures.isEmpty()) {
            HashMap<Integer, DialogTexture> hashMap = new HashMap<Integer, DialogTexture>();
            for (int pos : this.textures.keySet()) {
                DialogTexture dt = this.textures.get(pos);
                int lt = 0;
                boolean found = false;
                for (TextBlockClient textBlock4 : this.lines) {
                    lt += 1 + textBlock4.lines.size();
                    if (!textBlock4.equals(dt.line)) continue;
                    hashMap.put(lt - 1 - dt.height, dt);
                    found = true;
                    break;
                }
                if (found) continue;
                hashMap.put(pos, dt);
            }
            this.textures.clear();
            this.textures.putAll(hashMap);
        }
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (this.showOptions) {
            if (i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i() || i == 200) {
                --this.selected;
                --this.selectedStart;
                if (this.selected < 0) {
                    this.selected = 0;
                }
                this.checkSelected();
            }
            if (i == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i() || i == 208) {
                ++this.selected;
                ++this.selectedStart;
                if (this.selected >= this.options.size()) {
                    this.selected = this.options.size() - 1;
                }
                this.checkSelected();
            }
            if (i == 28) {
                this.handleDialogSelection();
            }
        }
        if (this.closeOnEsc && (i == 1 || this.isInventoryKey(i))) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.Dialog, this.dialog.id, -1);
            this.close();
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBottom) {
        if (!this.showOptions) {
            if (this.newDialogSet) {
                this.dialog.showFits = false;
                this.lineStart = this.lineTotal - this.lineVisibleSize;
                if (this.lineStart < 0) {
                    this.lineStart = 0;
                } else if (this.lineStart > this.lineTotal - this.lineVisibleSize) {
                    this.lineStart = this.lineTotal - this.lineVisibleSize;
                }
            }
            return;
        }
        if (this.scrollD != null) {
            this.scrollD[7] = -1;
            if (this.isMouseHover(mouseX, mouseY, this.scrollD[0], this.scrollD[4], this.scrollD[2] - this.scrollD[0], this.scrollD[5])) {
                if (this.isMouseHover(mouseX, mouseY, this.scrollD[0], this.scrollD[1], this.scrollD[2] - this.scrollD[0], this.scrollD[3] - this.scrollD[1])) {
                    this.scrollD[7] = mouseY;
                    this.scrollD[8] = this.lineStart;
                }
                return;
            }
        }
        if (this.scrollO != null) {
            this.scrollO[7] = -1;
            if (this.isMouseHover(mouseX, mouseY, this.scrollO[0], this.scrollO[4], this.scrollO[2] - this.scrollO[0], this.scrollO[5])) {
                if (this.isMouseHover(mouseX, mouseY, this.scrollO[0], this.scrollO[1], this.scrollO[2] - this.scrollO[0], this.scrollO[3] - this.scrollO[1])) {
                    this.scrollO[7] = mouseY;
                    this.scrollO[8] = this.selectedStart;
                }
                return;
            }
        }
        if (this.dialog.showWheel) {
            if (this.selectedWheel != 0) {
                if (this.selectedWheel == 1) {
                    --this.wheelList;
                    if (this.wheelList < 0) {
                        this.wheelList = 0;
                    }
                } else {
                    ++this.wheelList;
                    int max = (int)Math.ceil((double)this.options.size() / 6.0);
                    if (this.wheelList >= max) {
                        this.wheelList = max - 1;
                    }
                }
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                return;
            }
            if (this.selected < 0) {
                return;
            }
        } else if (!this.isMouseHover(mouseX, mouseY, this.guiLeft, this.dialogHeight, this.field_146294_l - this.guiLeft, this.field_146295_m - this.dialogHeight)) {
            return;
        }
        if (mouseBottom == 0) {
            this.handleDialogSelection();
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        int offsetLine;
        LogWriter.debug("TEST: ");
        if (this.scrollD != null && this.scrollD[7] > -1) {
            offsetLine = (int)(((float)this.scrollD[7] - (float)mouseY) / (float)this.scrollD[6]);
            if (offsetLine == 0) {
                return;
            }
            this.lineStart = this.scrollD[8] - offsetLine;
            if (this.lineStart < 0) {
                this.scrollD[8] = this.lineStart = 0;
                this.scrollD[7] = mouseY;
            } else if (this.lineStart > this.lineTotal - this.lineVisibleSize) {
                this.scrollD[8] = this.lineStart = this.lineTotal - this.lineVisibleSize;
                this.scrollD[7] = mouseY;
            }
        }
        if (this.scrollO != null && this.scrollO[7] > -1) {
            offsetLine = (int)(((float)this.scrollO[7] - (float)mouseY) / (float)this.scrollO[6]);
            if (offsetLine == 0) {
                return;
            }
            this.selectedStart = this.scrollO[8] - offsetLine;
            this.checkSelected();
        }
    }

    protected void resetOptions() {
        int max = this.guiSettings.dialogWidth - (int)(46.0f / this.corr);
        if (this.selectedSize > this.selectedVisibleSize) {
            max -= (int)(18.0f / this.corr);
        }
        this.options.clear();
        for (int slot : this.dialog.options.keySet()) {
            DialogOption option = this.dialog.options.get(slot);
            if (option == null || option.optionType == OptionType.DISABLED || !option.isAvailable((EntityPlayer)this.player)) continue;
            String optionText = NoppesStringUtils.formatText(option.title, new Object[]{this.player, this.dialogNpc});
            ArrayList<String> lines = new ArrayList<String>();
            if ((float)this.field_146289_q.func_78256_a(optionText) * this.corr > (float)max) {
                StringBuilder total = new StringBuilder();
                for (String sct : optionText.split(" ")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if ((float)this.field_146289_q.func_78256_a(stringBuilder.append((Object)total).append(" ").append(sct).toString()) * this.corr > (float)max) {
                        lines.add(total.toString());
                        total = new StringBuilder(sct);
                        continue;
                    }
                    if (total.length() > 0) {
                        total.append(" ");
                    }
                    total.append(sct);
                }
                if (total.length() > 0) {
                    lines.add(total.toString());
                }
            } else {
                lines.add(optionText);
            }
            this.options.put(slot, lines);
        }
        if (!this.closeOnEsc && this.options.isEmpty()) {
            this.closeOnEsc = true;
        }
    }

    @Override
    public void setClose(NBTTagCompound nbt) {
        this.grabMouse(false);
    }

    protected void setStartLine() {
        this.startLine = 0;
        for (TextBlockClient textBlock : this.lines) {
            ++this.startLine;
            for (ITextComponent line : textBlock.lines) {
                ++this.startLine;
            }
        }
    }

    static {
        icons.put(1, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/important.png"));
        icons.put(2, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/question.png"));
        icons.put(3, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/circle.png"));
        icons.put(4, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/joke.png"));
        icons.put(5, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/triangle.png"));
        icons.put(6, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/square.png"));
        icons.put(7, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/hexagon.png"));
        icons.put(8, new ResourceLocation("customnpcs", "textures/gui/dialog_option_icons/dice.png"));
    }

    public static class DialogTexture {
        public ResourceLocation res;
        public int left;
        public int uS;
        public int vS;
        public int height;
        public TextBlockClient line;

        protected DialogTexture(ResourceLocation r, int[] uv, TextBlockClient tb) {
            this.res = r;
            this.left = 0;
            this.uS = uv[0];
            this.vS = uv[1];
            this.height = uv[2];
            this.line = tb;
        }
    }
}

